import pandas as pd

# Load the CSV file
df = pd.read_csv('EgoMemory_samples.csv')

# Check if the reference_video column exists
if 'reference_video' not in df.columns:
    print("Error: 'reference_video' column not found in the CSV file.")
else:
    # Function to extract the filename by splitting on '\'
    def extract_file_name(path):
        # Check if the path is a valid string and non-empty
        if isinstance(path, str) and path.strip():
            # Split the path by '\' and get the last part
            return path.split("\\")[-1]
        else:
            return path  # If the path is invalid or empty, return it unchanged

    # Apply the function to the 'reference_video' column
    df['reference_video'] = df['reference_video'].apply(extract_file_name)

    # Save the modified dataframe back to a CSV
    df.to_csv('EgoMemory_samples_modified.csv', index=False)

    print("Reference video paths have been updated.")
